using System;
using System.Linq;

class Program{

    static void Main(){
        int N = int.Parse(Console.ReadLine());
        long[] X = Console.ReadLine().Split().Select(long.Parse).ToArray();
        long[] H = Console.ReadLine().Split().Select(long.Parse).ToArray();

        var A = X.Zip(H, (x, h) => (x, h)).OrderBy(p => p.x).ToArray();

        for (int I = 0; I < N; I++)
        {
            double ANS = double.MaxValue;

            if (I > 0)
                CHECK(A[I], A[I - 1], ref ANS);

            if (I + 1 < N)
                CHECK(A[I], A[I + 1], ref ANS);

            Console.WriteLine(ANS == double.MaxValue ? -1 : Math.Round(ANS, 6));
        }
    }

    static void CHECK((long x, long h) P, (long x, long h) Q, ref double ANS)
    {
        long DX = Q.x - P.x;
        long DH = Q.h - P.h;

        double MX = (P.x + Q.x + P.h - Q.h) / 2.0;
        double MY = (P.h + Q.h - Math.Abs(DX)) / 2.0;

        PROJ(P, -1, P.x + P.h, P.x, MX, ref ANS);

        PROJ(P, 1, Q.h - Q.x, MX, Q.x, ref ANS);
    }

    static void PROJ((long x, long h) P, int SIGN, double C,
                     double L, double R, ref double ANS)
    {
        double T = SIGN == 1
            ? (P.x + P.h - C) / 2
            : (P.x - P.h + C) / 2;

        if (T < L || T > R) return;

        double Y = SIGN == 1 ? T + C : -T + C;
        if (Y < P.h) return;

        double DX = P.x - T;
        double DY = P.h - Y;
        ANS = Math.Min(ANS, Math.Sqrt(DX * DX + DY * DY));
    }
}